/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceList;
import java.util.ArrayList;
import java.util.Collections;

public class DnaSequenceTree {
    private static final int PAD = 32;
    private Node[] myNode;
    private int myCapacity;
    private int myLength;
    private int myRoot;
    private long p0;
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private long p8;
    private long p9;
    private long pa;
    private long pb;
    private long pc;
    private long pd;
    private long pe;
    private long pf;

    public DnaSequenceTree(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("DnaSequenceTree(): C (= " + n + ") < 0, illegal");
        }
        this.myNode = new Node[n + 32];
        for (int i = 0; i < n; ++i) {
            this.myNode[i] = new Node();
        }
        this.myCapacity = n;
        this.myLength = 0;
        this.myRoot = -1;
    }

    public int capacity() {
        return this.myCapacity;
    }

    public int length() {
        return this.myLength;
    }

    public int root() {
        return this.myRoot;
    }

    public int parent(int n) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.parent(): Index (= " + n + ") out of bounds");
        }
        return this.myNode[n].parent;
    }

    public int child1(int n) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.child1(): Index (= " + n + ") out of bounds");
        }
        return this.myNode[n].child1;
    }

    public int child2(int n) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.child2(): Index (= " + n + ") out of bounds");
        }
        return this.myNode[n].child2;
    }

    public DnaSequence seq(int n) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.seq(): Index (= " + n + ") out of bounds");
        }
        return this.myNode[n].seq;
    }

    public void seq(int n, DnaSequence dnaSequence) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.seq(): Index (= " + n + ") out of bounds");
        }
        this.myNode[n].seq = dnaSequence;
    }

    public Double branchLength(int n) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.branchLength(): Index (= " + n + ") out of bounds");
        }
        return this.myNode[n].brlen;
    }

    public void branchLength(int n, Double d) {
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.branchLength(): Index (= " + n + ") out of bounds");
        }
        this.myNode[n].brlen = d;
    }

    public void clear() {
        int n = this.myCapacity;
        for (int i = 0; i < n; ++i) {
            this.myNode[i].clear();
        }
        this.myLength = 0;
        this.myRoot = -1;
    }

    public void copy(DnaSequenceTree dnaSequenceTree) {
        int n;
        if (this.myCapacity < dnaSequenceTree.myLength) {
            throw new IllegalArgumentException("DnaSequenceTree.copy(): Capacity (= " + this.myCapacity + ") too small");
        }
        int n2 = this.myCapacity;
        int n3 = dnaSequenceTree.myLength;
        for (n = 0; n < n3; ++n) {
            this.myNode[n].copy(dnaSequenceTree.myNode[n]);
        }
        for (n = n3; n < n2; ++n) {
            this.myNode[n].clear();
        }
        this.myLength = n3;
        this.myRoot = dnaSequenceTree.myRoot;
    }

    public void join(DnaSequenceTree dnaSequenceTree, DnaSequenceTree dnaSequenceTree2) {
        Node node;
        Node node2;
        int n;
        int n2 = dnaSequenceTree.myLength;
        int n3 = dnaSequenceTree2.myLength;
        if (this.myCapacity < n2 + n3 + 1) {
            throw new IllegalArgumentException("DnaSequenceTree.join(): Capacity (= " + this.myCapacity + ") too small");
        }
        int n4 = this.myCapacity;
        Node node3 = this.myNode[0];
        node3.parent = -1;
        node3.child1 = dnaSequenceTree.myRoot + 1;
        node3.child2 = dnaSequenceTree2.myRoot + n2 + 1;
        node3.seq = null;
        node3.brlen = null;
        for (n = 0; n < n2; ++n) {
            node2 = this.myNode[n + 1];
            node = dnaSequenceTree.myNode[n];
            node2.parent = node.parent == -1 ? 0 : node.parent + 1;
            node2.child1 = node.child1 == -1 ? -1 : node.child1 + 1;
            node2.child2 = node.child2 == -1 ? -1 : node.child2 + 1;
            node2.seq = node.seq;
            node2.brlen = node.brlen;
        }
        for (n = 0; n < n3; ++n) {
            node2 = this.myNode[n + n2 + 1];
            node = dnaSequenceTree2.myNode[n];
            node2.parent = node.parent == -1 ? 0 : node.parent + n2 + 1;
            node2.child1 = node.child1 == -1 ? -1 : node.child1 + n2 + 1;
            node2.child2 = node.child2 == -1 ? -1 : node.child2 + n2 + 1;
            node2.seq = node.seq;
            node2.brlen = node.brlen;
        }
        for (n = n2 + n3 + 1; n < n4; ++n) {
            this.myNode[n].clear();
        }
        this.myLength = n2 + n3 + 1;
        this.myRoot = 0;
    }

    public int add(int n, DnaSequence dnaSequence) {
        if (this.myLength == 0) {
            if (this.myCapacity < 1) {
                throw new IllegalArgumentException("DnaSequenceTree.add(): Capacity (= " + this.myCapacity + ") < 1, illegal");
            }
            Node node = this.myNode[0];
            node.parent = -1;
            node.child1 = -1;
            node.child2 = -1;
            node.seq = dnaSequence;
            node.brlen = null;
            this.myLength = 1;
            this.myRoot = 0;
            return 0;
        }
        if (this.myCapacity < this.myLength + 2) {
            throw new IllegalArgumentException("DnaSequenceTree.add(): Capacity (= " + this.myCapacity + ") too small");
        }
        if (0 > n || n >= this.myLength) {
            throw new IndexOutOfBoundsException("DnaSequenceTree.add(): Index (= " + n + ") out of bounds");
        }
        int n2 = this.myNode[n].parent;
        Node node = this.myNode[this.myLength];
        node.parent = n2;
        node.child1 = n;
        node.child2 = this.myLength + 1;
        node.seq = null;
        node.brlen = null;
        if (n2 == -1) {
            this.myRoot = this.myLength;
        } else if (this.myNode[n2].child1 == n) {
            this.myNode[n2].child1 = this.myLength;
        } else {
            this.myNode[n2].child2 = this.myLength;
        }
        this.myNode[n].parent = this.myLength;
        Node node2 = this.myNode[this.myLength + 1];
        node2.parent = this.myLength;
        node2.child1 = -1;
        node2.child2 = -1;
        node2.seq = dnaSequence;
        node2.brlen = null;
        this.myLength += 2;
        return this.myLength - 1;
    }

    public DnaSequenceList toList() {
        Object object;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = this.myLength;
        for (n = 0; n < n2; ++n) {
            object = this.myNode[n];
            if (((Node)object).child1 != -1) continue;
            arrayList.add(object);
        }
        Collections.sort(arrayList);
        n = arrayList.size();
        object = new DnaSequenceList();
        ((DnaSequenceList)object).mySequence = new DnaSequence[n];
        int n3 = 0;
        for (Node node : arrayList) {
            ((DnaSequenceList)object).mySequence[n3++] = node.seq;
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.myLength == 0) {
            stringBuilder.append('(');
            stringBuilder.append(')');
        } else if (this.myLength == 1) {
            stringBuilder.append('(');
            this.toString(stringBuilder, 0);
            stringBuilder.append(')');
        } else {
            this.toString(stringBuilder, this.myRoot);
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    private void toString(StringBuilder stringBuilder, int n) {
        Node node = this.myNode[n];
        if (node.child1 != -1) {
            stringBuilder.append('(');
            this.toString(stringBuilder, node.child1);
            stringBuilder.append(',');
            this.toString(stringBuilder, node.child2);
            stringBuilder.append(')');
        }
        stringBuilder.append(this.nodeName(node));
        if (node.brlen != null) {
            stringBuilder.append(':');
            stringBuilder.append(node.brlen);
        }
    }

    private String nodeName(Node node) {
        return node.seq == null || node.seq.myName == null ? "" : node.seq.myName.replaceAll("\\s+", "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node
    implements Comparable<Node> {
        public int parent;
        public int child1;
        public int child2;
        public DnaSequence seq;
        public Double brlen;
        private long p0;
        private long p1;
        private long p2;
        private long p3;
        private long p4;
        private long p5;
        private long p6;
        private long p7;
        private long p8;
        private long p9;
        private long pa;
        private long pb;
        private long pc;
        private long pd;
        private long pe;
        private long pf;

        public Node() {
            this.clear();
        }

        public void clear() {
            this.parent = -1;
            this.child1 = -1;
            this.child2 = -1;
            this.seq = null;
            this.brlen = null;
        }

        public void copy(Node node) {
            this.parent = node.parent;
            this.child1 = node.child1;
            this.child2 = node.child2;
            this.seq = node.seq;
            this.brlen = node.brlen;
        }

        @Override
        public int compareTo(Node node) {
            double d;
            double d2 = this.brlen == null ? 0.0 : this.brlen;
            double d3 = d = node.brlen == null ? 0.0 : node.brlen;
            if (d2 > d) {
                return -1;
            }
            if (d2 < d) {
                return 1;
            }
            return 0;
        }
    }
}

