% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_tests.R
\name{dcTest}
\alias{dcTest}
\title{Statistical test for differential association analysis}
\usage{
dcTest(dcscores, emat, condition, ...)
}
\arguments{
\item{dcscores}{a matrix, the result of the \code{dcScore} function. The
results should be passed as produced by the function and not modified in
intermediate steps}

\item{emat}{a matrix, data.frame, ExpressionSet, SummarizedExperiment or
DGEList. This should be the one passed to \code{dcScore}}

\item{condition}{a numeric, (with 1's and 2's representing a binary
condition), a factor with 2 levels or a character representing 2
conditions. This should be the one passed to \code{dcScore}}

\item{...}{see details}
}
\value{
a matrix, of p-values (or scores in the case of DiffCoEx and
  EBcoexpress) representing significance of differential associations.
  DiffCoEx will return scores as the publication specifies direct
  thresholding of scores and EBcoexpress returns posterior probabilities.
}
\description{
Perform statistical tests for scores generated using
  \code{dcScore}. Selects appropriate tests for the different methods used
  in computing scores. The exact test is selected based on the scoring method
  used and cannot be manually specified. Available tests include the z-test
  and permutation tests. Parallel computation supported for the permutation
  test.
}
\details{
Ensure that the score matrix passed to this function is the one
  produced by \code{dcScore}. Any modification to the result matrix will
  cause this function to fail. This is intended as the test need to be
  performed on the entire score matrix, not subsets.

  The appropriate test is chosen automatically based on the scoring method
  used. A z-test is performed for the z-score method while no tests are
  performed for DiffCoEx, EBcoexpress and FTGI. Permutation tests are
  performed for the remainder of methods by permutation sample labels.
  Statistics from a permutation are pooled such that statistics from all
  scores are used to evaluate a single observed score.

  Additional method specific parameters can be supplied to the function when
  performing permutation tests. \code{B} specifies the number of permutations
  to be performed and defaults to 20.

  If a cluster exists, computation in a permutation test will be performed in
  parallel (see examples).
}
\examples{
x <- matrix(rnorm(60), 2, 30)
cond <- rep(1:2, 15)
scores <- dcScore(x, cond, dc.method = 'mindy')
dcTest(scores, emat = x, condition = cond)

\dontrun{
#running in parallel
num_cores = 2
cl <- parallel::makeCluster(num_cores)
doSNOW::registerDoSNOW(cl) #or doParallel
set.seed(36) #for reproducibility
dcTest(scores, emat = x, condition = cond, B = 100)
parallel::stopCluster(cl)
}

}
\seealso{
\code{\link{dcMethods}}, \code{\link{dcScore}}
}
