% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference_methods_generic.R
\name{dcScore}
\alias{dcScore}
\alias{dcScore,matrix-method}
\alias{dcScore,Matrix-method}
\alias{dcScore,data.frame-method}
\alias{dcScore,ExpressionSet-method}
\alias{dcScore,SummarizedExperiment-method}
\alias{dcScore,DGEList-method}
\title{Compute scores from differential association analysis}
\usage{
dcScore(emat, condition, dc.method, ...)

\S4method{dcScore}{matrix}(emat, condition, dc.method = "zscore", ...)

\S4method{dcScore}{Matrix}(emat, condition, dc.method = "zscore", ...)

\S4method{dcScore}{data.frame}(emat, condition, dc.method = "zscore", ...)

\S4method{dcScore}{ExpressionSet}(emat, condition, dc.method = "zscore", ...)

\S4method{dcScore}{SummarizedExperiment}(emat, condition, dc.method = "zscore", ...)

\S4method{dcScore}{DGEList}(emat, condition, dc.method = "zscore", ...)
}
\arguments{
\item{emat}{a matrix, Matrix, data.frame, ExpressionSet, SummarizedExperiment
or DGEList}

\item{condition}{a numeric, (with 1's and 2's representing a binary
condition), a factor with 2 levels or a character representing 2 conditions}

\item{dc.method}{a character, representing the method to use. Use
\code{dcMethods()} to get a list of methods}

\item{...}{possible arguments are \code{cor.method}, \code{diffcoex.beta},
\code{ebcoexpress.useBWMC}, \code{ebcoexpress.plot}, \code{ldgm.lambda},
\code{ldgm.ntarget} and \code{ldgm.iter}. See details}
}
\value{
a matrix, of scores/statistics representing differential
  associations; p-values will be returned if FTGI is used and posterior
  probabilities if EBcoexpress is used.
}
\description{
Implementations and wrappers for existing implementations for
  methods inferring differential associations/co-expression. This method
  requires a matrix of expression and a binary condition to compute the
  differential association scores for all pairs of features (genes).
  Applications are not limited to analysis of gene expression data and may be
  used for differential associations in general.
}
\details{
When using data from sequencing experiments, make sure appropriate
  filtering for low counts and data transformation has been performed. Not
  doing so will affect estimation of correlation coefficients which most
  methods rely on.

  Additional method specific parameters can be supplied to the function.
  \code{cor.method} can be set to either 'pearson' (default) or 'spearman' to
  determine the method to use for estimating correlations. These are the two
  measures currently supported in the package. We recommend using the
  'spearman' correlation when dealing with sequencing data.

  The beta parameter in the DiffCoEx method can be specified using
  \code{diffcoex.beta} (defaults to 6). This enable soft thresholding of
  correlations similar to WGCNA.

  EBcoexpress specific parameters include \code{ebcoexpress.useBWMC}
  (defaults to \code{TRUE}) representing whether to use the bi-weight
  mid-correlation coefficient or not, and \code{ebcoexpress.plot} which plots
  the diagnostic plots if set to \code{TRUE} (defaults to \code{FALSE}).

  LDGM specific parameters include \code{ldgm.lambda}, \code{ldgm.ntarget}
  and \code{ldgm.iter}. \code{ldgm.lambda} specifies the L1 regularisation
  parameter to use when fitting the model. This can be tuned and specified by
  the user. Alternatively, this can be tuned such that the resulting network
  has a specified number of edges. In this case, \code{ldgm.ntarget} should
  be specified instead. \code{ldgm.iter} is the maximum number of iterations
  to perform when tuning \code{ldgm.lambda} using \code{ldgm.ntarget}
  (defaults to 50).

  EBcoexpress and GGM-based are implemented by providing interfaces to,
  or using functions from the \code{EBcoexpress}, \code{GeneNet}, and
  \code{COSINE} packages respectively. If using any of these methods, please
  \strong{cite} the appropriate packages and the appropriate methodology
  articles.
}
\examples{
x <- matrix(rnorm(60), 2, 30)
cond <- rep(1:2, 15)
dcScore(x, cond) #defaults to zscore
dcScore(x, cond, dc.method = 'diffcoex')

}
\seealso{
\code{\link{dcMethods}}
}
