% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation_functions.R
\name{dcEvaluate}
\alias{dcEvaluate}
\title{Evaluate performance of DC methods on simulations}
\usage{
dcEvaluate(
  simulation,
  dclist,
  truth.type = c("association", "influence", "direct"),
  perf.method = "f.measure",
  combine = TRUE,
  ...
)
}
\arguments{
\item{simulation}{a list, storing data and results generated from simulations}

\item{dclist}{a list of igraphs, produced using \code{dcPipeline}}

\item{truth.type}{a character, specifying which level of the true network to
retrieve: 'association' (default), 'influence' or 'direct'}

\item{perf.method}{a character, specifying the method to use. Available
methods can be accessed using \code{perfMethods}}

\item{combine}{a logical, indicating whether differential networks from
independent knock-outs should be treated as a single inference or
independent inferences (defaults to \code{TRUE})}

\item{...}{additional parameters to be passed on to the performance metric
method (see \code{performanceMeasure})}
}
\value{
a numeric, representing the performance metric. A single value if
  \code{combine = TRUE} and a named vector otherwise.
}
\description{
Quantify the performance of a differential co-expression
  pipeline on simulated data.
}
\examples{
data(sim102)

#run a standard pipeline
resStd <- dcPipeline(sim102, dc.func = 'zscore')
dcEvaluate(sim102, resStd)
dcEvaluate(sim102, resStd, combine = FALSE)

}
\seealso{
\code{\link{dcPipeline}}, \code{\link{performanceMeasure}},
  \code{\link{perfMethods}}
}
