% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_taxa.R
\name{step_subset_taxa}
\alias{step_subset_taxa}
\alias{step_subset_taxa,Recipe-method}
\alias{step_subset_taxa,PrepRecipe-method}
\title{Subset taxa by taxonomic level}
\usage{
step_subset_taxa(rec, tax_level, taxa, id = rand_id("subset_taxa"))

\S4method{step_subset_taxa}{Recipe}(rec, tax_level, taxa, id = rand_id("subset_taxa"))

\S4method{step_subset_taxa}{PrepRecipe}(rec, tax_level, taxa, id = rand_id("subset_taxa"))
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{tax_level}{The taxonomic level for subsetting taxa.}

\item{taxa}{The taxa to be retained in the dataset.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
A Recipe object that has been subsetted based on taxonomic level.
}
\description{
This is a convenience function around the subset_taxa function from the
phyloseq package. It is designed to speed up subsetting complex experimental
objects with one function call. In the case of run_subset_taxa,
the subsetting will be based on the taxonomic level of each taxon. The taxa
retained in the dataset are those where the taxonomic level matches the
provided taxa.
}
\details{
The function subsets the taxa in the phyloseq object based on the
provided taxonomic level and taxa. Only the taxa that match the provided
taxa at the given taxonomic level are retained in the phyloseq object.
}
\note{
This function modifies \code{rec} in place, you might want to make a copy of
\code{rec} before modifying it if you need to preserve the original object.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- recipe(metaHIV_phy, "RiskGroup2", "Species")
rec

## Define step_subset_taxa step with default parameters
rec <- step_subset_taxa(
  rec, 
  tax_level = "Kingdom",
  taxa = c("Bacteria", "Archaea")
)
rec
}
\seealso{
\code{\link[phyloseq]{subset_taxa}}
}
\concept{subset phy steps}
