% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_abundance.R
\name{step_filter_by_abundance}
\alias{step_filter_by_abundance}
\alias{step_filter_by_abundance,Recipe-method}
\alias{step_filter_by_abundance,PrepRecipe-method}
\title{Filter taxa by abundance}
\usage{
step_filter_by_abundance(
  rec,
  threshold = 0.01,
  id = rand_id("filter_by_abundance")
)

\S4method{step_filter_by_abundance}{Recipe}(
  rec,
  threshold = 0.01,
  id = rand_id("filter_by_abundance")
)

\S4method{step_filter_by_abundance}{PrepRecipe}(
  rec,
  threshold = 0.01,
  id = rand_id("filter_by_abundance")
)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{threshold}{The relative abundance threshold for filtering taxa,
expressed as a proportion of the total abundance. For example, a threshold
of 0.01 means that a taxon must make up at least 1\% of the total abundance
to be retained. The default value is 0.01.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
A Recipe object that has been filtered based on abundance.
}
\description{
This is a convenience wrapper around the filter_taxa function. It is intended
to speed up filtering complex experimental objects with one function call. In
the case of filter_by_abundance, the filtering will be based on the relative
abundance of each taxon. The taxa retained in the dataset are those where the
sum of their abundance is greater than the product of the total abundance and
the provided threshold.
}
\details{
The function calculates the total abundance of all taxa in the
phyloseq object. It then compares this total abundance to the abundance of
each individual taxon. If a taxon's abundance is less than the threshold
times the total abundance, that taxon is removed from the phyloseq object.
}
\note{
This function modifies \code{rec} in place, you might want to make a copy of
\code{rec} before modifying it if you need to preserve the original object.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- recipe(metaHIV_phy, "RiskGroup2", "Phylum")
rec

## Define filter_by_abundance step with default parameters
rec <- step_filter_by_abundance(rec, threshold = 0.01)
rec
}
\seealso{
\code{\link[phyloseq]{filter_taxa}}

Other filter phy steps: 
\code{\link{step_filter_by_prevalence}()},
\code{\link{step_filter_by_rarity}()},
\code{\link{step_filter_by_variance}()},
\code{\link{step_filter_taxa}()}
}
\concept{filter phy steps}
