% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-class.R
\name{recipe}
\alias{recipe}
\alias{Recipe}
\title{Create a Recipe for preprocessing data}
\usage{
recipe(
  microbiome_object = NULL,
  var_info = NULL,
  tax_info = NULL,
  steps = list()
)
}
\arguments{
\item{microbiome_object}{Phyloseq-class object or
TreeSummarizedExperiment-class object.}

\item{var_info}{A character string of column names corresponding to variables
that will be used in any context.}

\item{tax_info}{A character string of taxonomic levels that will be used in
any context.}

\item{steps}{list with steps.}
}
\value{
An object of class \code{Recipe} with sub-objects: \item{phyloseq}{object
of class \code{phyloseq} with taxa abundance information.} \item{var_info}{A
tibble that contains the current set of terms in the data set. This
initially defaults to the same data contained in \code{var_info}.}
\item{tax_info}{A tibble that contains the current set of taxonomic levels
that will be used in the analysis.}
}
\description{
A Recipe is a description of the steps to be applied to a data set in order
to prepare it for data analysis.
}
\examples{
data(metaHIV_phy)

## Define recipe
rec <-
  recipe(metaHIV_phy, var_info = "RiskGroup2", tax_info = "Phylum") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.3 * length(x))") |>
  step_metagenomeseq(rm_zeros = 0.01) |>
  step_maaslin()

## Prep recipe
da_results <- prep(rec)

## Consensus strategy
n_methods <- 2
da_results <- bake(da_results, count_cutoff = n_methods)

## Results
cool(da_results)

## You can also crate a recipe without var and tax info
rec <- recipe(metaHIV_phy)

rec

## And define them later
rec <- rec |>
  add_var("RiskGroup2") |>
  add_tax("Genus")

rec

## When trying to add an identical step to an existing one, the system
## returns an information message.
rec <- step_aldex(rec)
rec <- step_aldex(rec)

## The same with bake
da_results <- bake(da_results)
da_results <- bake(da_results)
}
