% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{import_steps}
\alias{import_steps}
\title{Import steps from json file}
\usage{
import_steps(rec, file, parallel = TRUE, workers = future::availableCores())
}
\arguments{
\item{rec}{A Recipe object.}

\item{file}{Path to the input file.}

\item{parallel}{if FALSE, no palatalization. if TRUE, parallel execution
using future and furrr packages.}

\item{workers}{Number of workers for palatalization.}
}
\value{
recipe-class object
}
\description{
Import steps from json file
}
\examples{
data(metaHIV_phy)

## Initialize the Recipe with a phyloseq object
rec <- recipe(metaHIV_phy, "RiskGroup2", "Species")
rec

## Import steps
json_file <- system.file("extdata", "test.json", package = "dar")
rec <- import_steps(rec, json_file)
rec

## If the json file contains 'bake', the Recipe is automatically prepared. 
json_file <- system.file("extdata", "test_bake.json", package = "dar")
rec <- 
  recipe(metaHIV_phy, "RiskGroup2", "Species") |>
  import_steps(json_file)
  
rec
cool(rec)
}
