% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sce_vdj}
\alias{sce_vdj}
\title{Example Dataset for V(D)J Analysis}
\format{
A \code{SingleCellExperiment} object with the following slots:
\describe{
\item{\code{colData}}{
A \code{DataFrame} containing metadata about each sample, corresponding
to \code{obs} in AnnData (Python).
The following columns are relevant for vignette usage:
\describe{
\item{\code{productive_(mode)_VDJ}, \code{productive_(mode)_VJ}}{
Factors indicating whether the heavy or light chain is
productive. \code{mode} refers to the
extraction mode for V(D)J genes and can be one of:
\itemize{
\item{\code{'abT'}}: TCR alpha-beta
\item{\code{'gdT'}}: TCR gamma-delta
\item{\code{'B'}}: BCR
}
}
\item{\code{Gene segment fields}}{
Gene segment annotations with column names in the format
\code{(v/d/j)_call_(mode)_(VDJ/VJ)}.
Examples include:
\itemize{
\item{\code{v_call_abT_VDJ}}: V gene for TCR alpha-beta
VDJ recombination
\item{\code{d_call_abT_VJ}}: D gene for TCR alpha-beta
VJ recombination
}
}
\item{\code{chain_status}}{
A factor describing the receptor chain's status.
}
\item{\code{anno_lvl_2_final_clean}}{
Cell type annotations.
}
}
}
\item{\code{int_colData}}{
A \code{DataFrame} containing additional assay metadata important for further
analysis. Includes:
\itemize{
\item{\code{X_scvi}}: A dimensionality reduction matrix from the
scVI model.
\item{\code{UMAP}}: A UMAP reduction matrix.
}
}
}
}
\source{
Suo et al., 2024, \emph{Nature Biotechnology}.\cr
\url{https://www.nature.com/articles/s41587-023-01734-7}.
}
\usage{
data(sce_vdj)
}
\description{
The \code{sce_vdj} object is a down-sampled demo dataset derived from
Suo et al., 2024, \emph{Nature Biotechnology}. \cr
This dataset is used in vignettes to demonstrate workflows for V(D)J
analysis. \cr For details, see the original
publication at \url{https://www.nature.com/articles/s41587-023-01734-7}.
}
\examples{
data(sce_vdj)
}
\keyword{datasets}
