% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterCells.R
\name{.filterCells}
\alias{.filterCells}
\title{.filterCells}
\usage{
.filterCells(
  sce,
  col_n,
  filter_pattern = ",|None|No_contig",
  remove_missing = TRUE
)
}
\arguments{
\item{sce}{SingleCellExperiment object, adata in python
data after combineTCR, contain both vdj and seq}

\item{col_n}{mode for extraction the V(D)J genes.}

\item{filter_pattern}{character string,
optional ',|None|No_contig' by default}

\item{remove_missing}{bool, True by default
\itemize{
\item If \code{TRUE}, will remove cells with contigs matching the filter from
the object.
\item If \code{FALSE}, will mask them with a uniform value dependent on the column
name.
}}
}
\value{
filtered SingleCellExperiment object according to the parameter.
}
\description{
Helper function that identifies filter_pattern hits in determined column of
sce, and then either removes the offeending cells or masks
the matched values with a uniform value of '(column's name)_missing'
}
\keyword{internal}
