% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentiationProbabilities.R
\name{differentiationProbabilities}
\alias{differentiationProbabilities}
\title{Compute Branch Probabilities Using Markov Chain}
\usage{
differentiationProbabilities(
  wp_data,
  terminal_states = NULL,
  knn = 30L,
  pseudotime,
  waypoints,
  verbose = TRUE,
  use_RANN = TRUE
)
}
\arguments{
\item{wp_data}{A multi-scale data matrix or data frame representing the
waypoints.}

\item{terminal_states}{Integer vector. Indices of the terminal states.
Default is \code{NULL}.}

\item{knn}{Integer. Number of nearest neighbors for graph construction.
Default is \code{30L}.}

\item{pseudotime}{Numeric vector. Pseudotime ordering of cells.}

\item{waypoints}{Integer vector. Indices of selected waypoints used to
construct the Markov chain.}

\item{verbose}{Boolean, whether to print messages/warnings.}

\item{use_RANN}{parameter to make user choose
whether to use RANN to construct Markov chain,
or keep using bluster}
}
\value{
A numeric matrix or data frame containing branch probabilities
for each waypoint.
}
\description{
This function calculates branch probabilities for differentiation
trajectories based on a Markov chain constructed from waypoint data and
pseudotime ordering.
}
