% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-DamIDResults.R
\name{expressed}
\alias{expressed}
\alias{expressed,DamIDResults-method}
\title{Get expressed genes/loci by FDR}
\usage{
expressed(object, condition, fdr = 0.05, which = "any")
}
\arguments{
\item{object}{A \code{DamIDResults} object. This object must have been generated
from data loaded with \code{load_data_genes(calculate_fdr = TRUE)} for the
underlying FDR columns to be present.}

\item{condition}{A character string identifying the experimental condition to filter.
This can be the internal identifier or the user-friendly display name.}

\item{fdr}{Numeric. The FDR cutoff. Defaults to 0.05.}

\item{which}{Character string, either 'any' or 'all'. Determines whether a gene
must pass the FDR threshold in any or all replicates of the condition.
Defaults to 'any'.}
}
\value{
A \code{data.frame} containing the \code{gene_name} and \code{gene_id} of
  genes that pass the filter.
}
\description{
A method to filter genes or loci that are considered 'expressed'
  in a specific condition, based on a False Discovery Rate (FDR) threshold.
  The method is a wrapper around the \code{\link{filter_genes_by_fdr}} function.
}
\examples{
# Helper function to create a sample DamIDResults object with FDR data
.generate_fdr_example_results <- function() {
    occupancy_df <- data.frame(
        gene_name = c("geneA", "geneB", "geneC"),
        gene_id = c("FBgn01", "FBgn02", "FBgn03"),
        L4_rep1_FDR = c(0.01, 0.10, 0.04),
        L4_rep2_FDR = c(0.03, 0.02, 0.50),
        L5_rep1_FDR = c(0.80, 0.90, 0.01),
        row.names = c("geneA", "geneB", "geneC")
    )
    diff_results_base <- list(occupancy = occupancy_df, test_category = "expressed")
    new("DamIDResults",
        analysis = data.frame(row.names = rownames(occupancy_df)),
        upCond1 = data.frame(), upCond2 = data.frame(),
        cond = c("L4 Neurons" = "L4", "L5 Neurons" = "L5"),
        data = diff_results_base
    )
}
mock_fdr_results <- .generate_fdr_example_results()

# Get genes expressed in L4 neurons (FDR <= 0.05 in any replicate)
expressed(mock_fdr_results, condition = "L4 Neurons")

# Get genes expressed in L5 neurons with a stricter fdr
expressed(mock_fdr_results, condition = "L5", fdr = 0.02)

}
\seealso{
\code{\link{filter_genes_by_fdr}}, \code{\link{DamIDResults-class}},
  \code{\link{load_data_genes}}
}
