% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareProteome.R
\name{prepareProteome}
\alias{prepareProteome}
\title{prepare proteome for background building}
\usage{
prepareProteome(source, fasta, species = "unknown", ...)
}
\arguments{
\item{source}{An object of \code{\link{UniProt.ws}} or A character "UniProt".}

\item{fasta}{fasta file name or an object of AAStringSet}

\item{species}{an character to assign the species of the proteome}

\item{...}{parameters could be passed to \link{prepareProteomeByFTP}.}
}
\value{
an object of Proteome which contain protein sequence information.
}
\description{
prepare proteome from UniProt webserver or a fasta file
}
\examples{
if(interactive()){
   library(UniProt.ws)
   availableUniprotSpecies("Drosophila melanogaster")
   UniProt.ws <- UniProt.ws(taxId=7227)
   proteome <- prepareProteome(UniProt.ws, species="Drosophila melanogaster")
 }
}
\seealso{
\code{\link{formatSequence}}, \code{\link{buildBackgroundModel}}
}
\author{
Jianhong Ou
}
\keyword{misc}
