% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDStructurome.R
\name{plotDStructurome}
\alias{plotDStructurome}
\title{Plots differentially reactive regions.}
\usage{
plotDStructurome(
  rl,
  diff_regions,
  outfile,
  fdr = 0.05,
  ylim = c(-0.05, 3),
  del_d_cutoff = 0.01
)
}
\arguments{
\item{rl}{List of dataframes of reactivities for each sample.}

\item{diff_regions}{Output from dStruct or dStructGuided containing coordinates of regions with significance of differentially reactivity.}

\item{outfile}{The name for pdf file which will be saved.}

\item{fdr}{FDR threshold for plotted regions.}

\item{ylim}{Y-axis limits for plots.}

\item{del_d_cutoff}{Minimum effect size for plotted regions specified in terms of median difference of the between-group and within-group d-scores.}
}
\value{
Saves a PDF for all differentially reactive regions. Returns NULL.
}
\description{
Given the table of results from dStruct or dStructGuided and the
corresponding lists with reactivity scores for all transcripts, this function saves
a PDF file with detailed visualizations of reactivities for all differential regions.
}
\examples{
#Load data from Lai et al., 2019
data(lai2019)

#Run dStruct in de novo discovery mode for all the transcripts in this data in one step.
res <- dStructome(lai2019, 3, 2, batches= TRUE, min_length = 21,
    between_combs = data.frame(c("A3", "B1", "B2")),
    within_combs = data.frame(c("A1", "A2", "A3")),
    ind_regions = TRUE, processes = 1)

#Plot the significant results and save to a PDF file.
plotDStructurome(rl = lai2019,
    diff_regions = res,
    outfile = "significantly_differential_regions",
    fdr = 0.05,
    ylim = c(-0.05, 3))
}
\references{
Choudhary, K., Lai, Y. H., Tran, E. J., & Aviran, S. (2019).
dStruct: identifying differentially reactive regions from RNA
structurome profiling data. \emph{Genome biology}, 20(1), 1-26.
}
\author{
Krishna Choudhary
}
