% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoFilterClass.R
\name{reducedFlowframe,MarginEvents-method}
\alias{reducedFlowframe,MarginEvents-method}
\title{accesor method for reduced flowframe (MarginEvent class)}
\usage{
\S4method{reducedFlowframe}{MarginEvents}(x)
}
\arguments{
\item{x}{an object of class MarginEvents}
}
\value{
reduced Flowframe method for MarginEvents
}
\description{
accesor method for reduced flowframe (MarginEvent class)
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                  package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
reducedFlowframe(cells_nonmargin)
}
