% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChannels.R
\name{getChannel}
\alias{getChannel}
\title{returns the channel with more than one peak present. 
It returns NA if there is only one peak present.}
\usage{
getChannel(flowfile, ch, ph)
}
\arguments{
\item{flowfile}{flowframe after debris are removed.}

\item{ch}{channel to be checked for multiple peaks.}

\item{ph}{maximum peak height to be ignored. This allows 
ignoring of tiny peaks that could
affect the gating process.}
}
\value{
name of channel with more than one peak

 @examples 
 flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                  package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, 
                               emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
getChannel(flowfile_logtrans, 'RED.B.HLin', 0.05)
}
\description{
returns the channel with more than one peak present. 
It returns NA if there is only one peak present.
}
