% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_extract.R
\name{clusterExtract}
\alias{clusterExtract}
\title{extract clusters based on supplied cluster indicator}
\usage{
clusterExtract(flowfile, cluster_var = "Clusters", cluster_val = NULL)
}
\arguments{
\item{flowfile}{flowframe containing cluster indicators as well}

\item{cluster_var}{column name in expression matrix containing the cluter 
indicators, cannot be NULL.}

\item{cluster_val}{cluster number, cannot be NULL.}
}
\value{
flowFrame containing the clusters
}
\description{
extract clusters based on supplied cluster indicator
}
\examples{

flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                             package = "cyanoFilter",
                             mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
                                         c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
                              Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
fin <- phytoFilter(flowfile = reducedFlowframe(cells_nonmargin),
              pig_channels = c("RED.B.HLin", "YEL.B.HLin", "RED.R.HLin"),
              com_channels = c("FSC.HLin", "SSC.HLin"))

clusterExtract(flowfile = reducedFlowframe(fin),
    cluster_var = "Clusters",
    cluster_val = 1)

}
