% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareAnnotationRefseq.R
\name{PrepareAnnotationRefseq}
\alias{PrepareAnnotationRefseq}
\title{prepare annotation for Refseq}
\usage{
PrepareAnnotationRefseq(genome = "hg19", CDSfasta, pepfasta, annotation_path,
  dbsnp = NULL, transcript_ids = NULL, splice_matrix = FALSE,
  ClinVar = FALSE, ...)
}
\arguments{
\item{genome}{specify the UCSC DB identifier (e.g. "hg19")}

\item{CDSfasta}{path to the fasta file of coding sequence.}

\item{pepfasta}{path to the fasta file of protein sequence, check 'introduction' for more detail.}

\item{annotation_path}{specify a folder to store all the annotations.}

\item{dbsnp}{specify a snp dataset to be used for the SNP annotation, default is NULL. (e.g. "snp148")}

\item{transcript_ids}{optionally, only retrieve transcript annotation data for the specified set of transcript ids. Default is NULL.}

\item{splice_matrix}{whether generate a known exon splice matrix from the annotation. this is not necessary if you don't want to analyse junction results, default is FALSE.}

\item{ClinVar}{whether to download ClinVar data, default is FALSE.}

\item{...}{additional arguments}
}
\value{
several .RData file containing annotations needed for further analysis.
}
\description{
prepare the annotation for Refseq through UCSC table browser.
}
\examples{
\dontrun{

transcript_ids <- c("NM_001126112", "NM_033360", "NR_073499", "NM_004448",
        "NM_000179", "NR_029605", "NM_004333", "NM_001127511")
pepfasta <- system.file("extdata", "refseq_pro_seq.fasta", 
            package="customProDB")
CDSfasta <- system.file("extdata", "refseq_coding_seq.fasta", 
            package="customProDB")
annotation_path <- tempdir()
PrepareAnnotationRefseq(genome='hg38', CDSfasta, pepfasta, annotation_path, 
            dbsnp=NULL, transcript_ids=transcript_ids, 
            splice_matrix=FALSE, ClinVar=FALSE)

}
}
\author{
Xiaojing Wang
}

