% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugage_annot.R
\name{buildDrugAgeDB}
\alias{buildDrugAgeDB}
\title{Build DrugAge Annotation Database}
\usage{
buildDrugAgeDB(
  da_path = system.file("extdata/drugage_id_mapping.tsv", package = "customCMPdb"),
  dest_path
)
}
\arguments{
\item{da_path}{character(1), file path to the tabular file generated from
\code{processDrugage} function and manually edited the missing IDs.}

\item{dest_path}{character(1), destination path of the result DrugAge 
annotation SQLite database}
}
\value{
DrugAge annotation SQLite database
}
\description{
This function builds the DrugAge annotation SQLite database from the 
'drugage_id_mapping' table stored in the 'inst/extdata' directory of this 
package. The 'drugage_id_mapping.tsv' table contains the DrugAge compounds 
annotation information (such as species, avg_lifespan_change etc) as well 
as the compound name to ChEMBL id and PubChem id mappings.
}
\details{
Part of the id mappings in the 'drugage_id_mapping.tsv' table is generated 
by the \code{processDrugage} function for compound names that have ChEMBL 
ids from the ChEMBL database (version 24). The missing IDs were added 
manually. A semi-manual approach was to use this web service: 
\url{https://cts.fiehnlab.ucdavis.edu/batch}. After the semi-manual process,
the left ones were manually mapped to ChEMBL, PubChem and DrugBank ids. 
The mixed items were commented.
}
\examples{
buildDrugAgeDB(dest_path=tempfile(fileext="_drugage.db"))
}
