## ---- echo = FALSE, message = FALSE--------------------------------------
library(ctsGE)
library(pander)
library(rmarkdown)

## ----eval=FALSE,warning=FALSE,message=FALSE------------------------------
#  source("https://bioconductor.org/biocLite.R")
#  biocLite("ctsGE")

## ----eval=FALSE,message=FALSE, warning=FALSE-----------------------------
#  library(GEOquery)
#  
#  gse2077 <- getGEO('GSE2077')
#  gseAssays <- Biobase::assayData(gse2077)
#  gseExprs <- Biobase::assayDataElement(gseAssays[[1]][,c(1:6)],'exprs')
#  
#  # list of the time series tables use only 6 samples
#  gseList <- lapply(1:6,function(x){data.frame(Genes = rownames(gseExprs),Value = gseExprs[,x])})
#  names(gseList) <- colnames(gseExprs)

## ----eval=FALSE,message=FALSE,warning=FALSE------------------------------
#  rts <- readTSGE(gseList,labels = c("0h","6h","12h","24h","48h","72h"))

## ---- message=FALSE,warning=FALSE----------------------------------------
data_dir <- system.file("extdata", package = "ctsGE")
files <- dir(path=data_dir,pattern = "\\.xls$")

## ----message=FALSE,warning=FALSE-----------------------------------------

rts <- readTSGE(files, path = data_dir, labels = c("0h","6h","12h","24h","48h","72h") )

## ----message=FALSE,warning=FALSE-----------------------------------------
names(rts)
rts$timePoints
head(rts$samples)
head(rts$tags)

## ---- echo=FALSE,results='asis'------------------------------------------

panderOptions("table.style","rmarkdown")
pander(head(rts$tsTable))


## ----message=FALSE,warning=FALSE-----------------------------------------

prts <- PreparingTheIndexes(x = rts, min_cutoff=0.5, max_cutoff=0.7, mad.scale = TRUE)


## ----message=FALSE,warning=FALSE-----------------------------------------

prts$cutoff


## ----message=FALSE,warning=FALSE,echo=FALSE------------------------------
library(dplyr)

count_zero <- 
  function(x){
    sum(strsplit(x,"")[[1]]==0)}


tbl <- prts$index %>%
    # counting genes at each index
    group_by(index)%>% summarise(size=length(index)) %>% 
    # counting the number of zeros at each index
    group_by(index)%>% mutate(nzero=count_zero(as.character(index))) %>% 
    # groups genes by the number of zeros and sum them
    group_by(nzero) %>% summarise(genes=round(sum(size)/12625,1)) 

tmp = which(0:6%in%tbl$nzero==0)-1
tmp_df = data.frame(nzero=tmp,genes=rep(0,length(tmp)))
tbl <- bind_rows(tbl,tmp_df) %>% arrange(nzero)
labs <- seq(0,max(tbl$genes), by = 0.2)
barplot(tbl$genes, 
        main = paste("Number of zeros in indexes with cutoff =",prts$cutoff), 
        names.arg = tbl$nzero,axes = FALSE, xlab="Number of Zeros")
axis(side = 2, at = labs, labels = paste0(labs * 100, "%"))

## ---- message=FALSE,warning=FALSE----------------------------------------
prts <- PreparingTheIndexes(x = rts, mad.scale = TRUE) 
names(prts)

## ----message=FALSE,echo=FALSE,warning=FALSE,results="asis"---------------

panderOptions("table.style","simple")
pander(head(prts$scaled)) 

## ----message=FALSE,echo=FALSE,warning=FALSE,results="asis"---------------

panderOptions("table.style","simple")
pander(head(prts$index)) 

## ----message=FALSE, warning=FALSE,eval=FALSE-----------------------------
#  ClustIndexes <- ClustIndexes(prts, scaling = TRUE)
#  names(ClustIndexes)
#  # table of the index and the recommended k that were found by the function
#  head(ClustIndexes$optimalK)
#  
#  # Table of clusters index for each gene
#  head(ClustIndexes$ClusteredIdxTable)

## ----message=FALSE,warning=FALSE-----------------------------------------
indexPlot <- PlotIndexesClust(prts,idx = "1100-1-1",scaling = TRUE)
names(indexPlot)

## ----message=FALSE,warning=FALSE,echo=FALSE------------------------------
length(indexPlot$graphs)

## ----message=FALSE,warning=FALSE,results="asis",echo=FALSE---------------

panderOptions("table.style","rmarkdown")
pander(head(indexPlot[[1]]))

## ----message=FALSE,warning=FALSE-----------------------------------------
indexPlot$graphs

## ----message=FALSE,warning=FALSE,eval=FALSE------------------------------
#  library(shiny)
#  library(DT)
#  ctsGEShinyApp(rts)

