% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{treeTest}
\alias{treeTest}
\title{Perform multivariate testing along a hierarchy}
\usage{
treeTest(
  fit,
  obj,
  hc,
  coef,
  method = c("FE.empirical", "FE", "RE2C", "tstat", "sidak", "fisher"),
  shrink.cov = TRUE
)
}
\arguments{
\item{fit}{\code{MArrayLM} object return by \code{lmFit()} or \code{dream()}}

\item{obj}{\code{EList} object returned by \code{voom()}}

\item{hc}{hierarchical clustering as an \code{hclust} object}

\item{coef}{name of coefficient to be extracted}

\item{method}{statistical method used to perform multivariate test.  See details.  \code{'FE'} is a fixed effect test that models the covariance between coefficients. \code{'FE.empirical'} use compute empirical p-values by sampling from the null distribution and fitting with a gamma. \code{'RE2C'} is a random effect test of heterogeneity of the estimated coefficients that models the covariance between coefficients, and also incorporates a fixed effects test too. \code{'tstat'} combines the t-statistics and models the covariance between coefficients. \code{'sidak'} returns the smallest p-value and accounting for the number of tests. \code{'fisher'} combines the p-value using Fisher's method assuming independent tests.}

\item{shrink.cov}{shrink the covariance matrix between coefficients using the Schafer-Strimmer method}
}
\value{
object of type \code{treedata} storing results
}
\description{
Perform multivariate testing using \code{mvTest()} along the nodes of tree
}
\details{
See package \code{remaCor} for details about the \code{remaCor::RE2C()} test, and see \code{remaCor::LS()} for details about the fixed effect test.  When only 1 feature is selected, the original t-statistic and p-value are returned.
}
\examples{
library(variancePartition)

# Load cell counts, clustering and metadata
# from Kang, et al. (2018) https://doi.org/10.1038/nbt.4042
data(IFNCellCounts)

# Apply crumblr transformation
cobj <- crumblr(df_cellCounts)

# Use dream workflow to analyze each cell separately
fit <- dream(cobj, ~ StimStatus + ind, info)
fit <- eBayes(fit)

# Perform multivariate test across the hierarchy
res <- treeTest(fit, cobj, hcl, coef = "StimStatusstim")

# Plot hierarchy and testing results
plotTreeTest(res)

# Extract results for first 3 nodes
res[1:3, ]
}
\seealso{
\code{variancePartition::mvTest()}
}
