% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPfamDomains.R
\name{preparePfamTable}
\alias{preparePfamTable}
\title{Obtain Pfam domains from biomaRt}
\usage{
preparePfamTable(txObject, mart_dataset)
}
\arguments{
\item{txObject}{A \linkS4class{TxDb} object or a
\linkS4class{GRangesList} object obtained using
\code{\link{TxDb2GRangesList}} to provide a 
gene model annotation.}

\item{mart_dataset}{String specifying dataset to be used by \pkg{biomaRt}
for Pfam domains annotation . E.g. "hsapiens_gene_ensembl".}
}
\value{
A \linkS4class{DataFrame} object with the following columns:

\itemize{
\item \code{ensembl_transcript_id} Ensembl transcript ID.
\item \code{pfam} Pfam domain name.
\item \code{pfam_start} Start amino acid coordinate of the Pfam domain.
\item \code{pfam_end} End amino acid coordinate of the Pfam domain.
}
}
\description{
Obtain Pfam domains from biomaRt for all
   transcripts found in a gene model object.
}
\examples{
data(grListExample, package="crisprDesign")

if (interactive()){
    pfamTable <- preparePfamTable(grListExample,
                                  mart_dataset="hsapiens_gene_ensembl")
}

}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
