% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addTssAnnotation.R
\name{addTssAnnotation}
\alias{addTssAnnotation}
\alias{addTssAnnotation,GuideSet-method}
\alias{addTssAnnotation,PairedGuideSet-method}
\alias{addTssAnnotation,NULL-method}
\title{Add TSS context annotation to a \linkS4class{GuideSet} object}
\usage{
addTssAnnotation(object, ...)

\S4method{addTssAnnotation}{GuideSet}(
  object,
  tssObject,
  anchor = c("cut_site", "pam_site"),
  tss_window = NULL,
  ignore.strand = TRUE
)

\S4method{addTssAnnotation}{PairedGuideSet}(
  object,
  tssObject,
  anchor = c("cut_site", "pam_site"),
  tss_window = NULL,
  ignore.strand = TRUE
)

\S4method{addTssAnnotation}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{tssObject}{A \linkS4class{GRanges} object containing TSS coordinates
and annotation.}

\item{anchor}{A character string specifying which gRNA-specific coordinate
to use (\code{cut_site} or \code{pam_site}) when searching for
overlapping TSS regions. "cut_site" by default.}

\item{tss_window}{A numeric vector of length 2 establishing the window size
of the genomic region around the TSS to include as the "TSS region".
The values set the upstream and downstream limits, respecitvely. The
default is \code{c(-500, 500)}, which includes 500bp upstream (note the
negative value) and downstream of the TSS.}

\item{ignore.strand}{If \code{TRUE} (default), includes annotation for
gRNAs irrespective of their target strand. Otherwise, only gRNAs
targeting the gene strand will be annotated.}
}
\value{
A \linkS4class{GuideSet} object with a \code{tssAnnotation} list
    column stored in \code{mcols(guideSet)}. See details section for
    descriptions of TSS annotation columns.
}
\description{
Add transcription start site (TSS) context annotation to
    spacer sequences stored in a \linkS4class{GuideSet} object.
}
\details{
\code{mcols(guideSet)[["tssAnnotation"]]} includes all columns from
    \code{mcols(tssObject)} in addition to the columns described below.

\itemize{
\item \code{chr} — gRNA chromosome name.
\item \code{anchor_site} — Genomic coordinate used to search for overlapping
    TSS regions.
\item \code{strand} — Strand the gRNA is located on.
\item \code{tss_id} — The ID for the TSS in \code{tssObject}, if present.
\item \code{tss_strand} — Strand the TSS is located on, as provided in
    \code{tssObject}
\item \code{tss_pos} — Genomic coordinate of the TSS, as provided in
    \code{tssObject}.
\item \code{dist_to_tss} — Distance (in nucleotides) between the gRNA
    \code{anchor_site} and \code{tss_pos}. Negative values indicate
    gRNA targets upstream of the TSS.
}
}
\examples{
data(guideSetExample, package="crisprDesign")
data(tssObjectExample, package="crisprDesign")
guideSet <- addTssAnnotation(guideSetExample,
                             tssObject=tssObjectExample)

# To access TSS annotation:
ann <- tssAnnotation(guideSet)

}
\seealso{
\code{\link{addGeneAnnotation}} to add gene annotation, and
    \code{\link{tssAnnotation}} to retrieve an existing TSS annotation.
}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
