% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addRepeats.R
\name{addRepeats}
\alias{addRepeats}
\alias{addRepeats,GuideSet-method}
\alias{addRepeats,PairedGuideSet-method}
\alias{addRepeats,NULL-method}
\title{Annotate a \linkS4class{GuideSet} object with repeat elements}
\usage{
addRepeats(object, ...)

\S4method{addRepeats}{GuideSet}(object, gr.repeats = NULL, ignore.strand = TRUE)

\S4method{addRepeats}{PairedGuideSet}(object, gr.repeats = NULL, ignore.strand = TRUE)

\S4method{addRepeats}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{gr.repeats}{A \linkS4class{GRanges} object containing repeat
elements regions.}

\item{ignore.strand}{Should gene strand be ignored when annotating?
TRUE by default.}
}
\value{
\code{guideSet} with an \code{inRepeats} column appended in
    \code{mcols(guideSet)} that signifies whether the spacer sequence
    overlaps a repeat element.
}
\description{
Add an annotation column to a \linkS4class{GuideSet} object
    that identifies spacer sequences overlapping repeat elements.
}
\examples{
data(guideSetExample, package="crisprDesign")
data(grRepeatsExample, package="crisprDesign")
guideSet <- addRepeats(guideSetExample,
                       gr.repeats=grRepeatsExample)

}
\seealso{
\code{link{removeRepeats}}.
}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
