% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addReinitiationFlag.R
\name{addReinitiationFlag}
\alias{addReinitiationFlag}
\title{Add a logical flag for gRNAs leading to potential reinitiation}
\usage{
addReinitiationFlag(
  guideSet,
  tx_id,
  grnaLocationUpperLimit = 150,
  cdsCutoff = 0.2
)
}
\arguments{
\item{guideSet}{A \linkS4class{GuideSet} object.}

\item{tx_id}{String specifiying Ensembl ID for the 
isoform transcript of interested. E.g. "ENST00000311936".}

\item{grnaLocationUpperLimit}{Integer value specifying the number of 
nucleotides upstream of the start of the CDS in which to search 
for problematic gRNAs. Default value is 150. gRNAS beyond this
value will not be flagged.}

\item{cdsCutoff}{Numeric value between 0 and 1 to specify the percentage 
of the CDS in which to search for problematic gRNAs.
Default is 0.20. gRNAS beyond this value will not be flagged.}
}
\value{
The original \code{object} with an appended column 
    \code{reinitiationFlag} with logical values. A \code{TRUE} value
    indicates a gRNA in proximity of a potential reinitiation site,
    and therefore should be avoided.
}
\description{
Add a logical flag for gRNAs leading to potential reinitiation.
}
\author{
Jean-Philippe Fortin
}
