% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsDesign.R
\name{addOpsBarcodes}
\alias{addOpsBarcodes}
\title{Add optical pooled screening (OPS) barcodes}
\usage{
addOpsBarcodes(guideSet, n_cycles = 9, rt_direction = c("5prime", "3prime"))
}
\arguments{
\item{guideSet}{A \linkS4class{GuideSet} object.}

\item{n_cycles}{Integer specifying the number of sequencing 
cycles used in the in situ sequencing. This effectively
determines the length of the barcodes to be used for
sequencing.}

\item{rt_direction}{String specifying from which direction
the reverse transcription of the gRNA spacer sequence
will occur. Must be either "5prime" or "3prime".
"5prime" by default.}
}
\value{
The original \code{guideSet} object with an additional
    column \code{opsBarcode} stored in \code{mcols(guideSet)}.
    The column is a \code{DNAStringSet} storing the OPS
    barcode.
}
\description{
Add optical pooled screening (OPS) barcodes.
}
\examples{
data(guideSetExample, package="crisprDesign")
guideSetExample <- addOpsBarcodes(guideSetExample)

}
\author{
Jean-Philippe Fortin
}
