% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addNtcs.R
\name{addNtcs}
\alias{addNtcs}
\alias{addNtcs,GuideSet-method}
\alias{addNtcs,PairedGuideSet-method}
\alias{addNtcs,NULL-method}
\title{Add non-targeting control (NTC) sequences to \linkS4class{GuideSet}}
\usage{
addNtcs(object, ...)

\S4method{addNtcs}{GuideSet}(object, ntcs)

\S4method{addNtcs}{PairedGuideSet}(object, ntcs)

\S4method{addNtcs}{NULL}(object, ...)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{ntcs}{A named character vector of NTC sequences. Sequences must
consist of appropriate DNA or RNA bases, and have the same spacer length
as spacers in \code{object}. Vector names are assigned as IDs and
seqlevels, and must be unique and distinct from IDs and seqnames present
in \code{object}.}
}
\value{
The original \code{object} with appended \code{ntcs} spacers.
    Pre-existing annotation in \code{object} will be set to \code{NA} or
    empty list elements for appended NTC spacers.
}
\description{
Add non-targeting control (NTC) sequences to a
    \linkS4class{GuideSet} object.
}
\details{
NTC sequences are appended as spacers to the \linkS4class{GuideSet}
    object. Each NTC sequence is assigned to its own "chromosome" in the
    \code{ntc} genome, as reflected in the \linkS4class{Seqinfo} of the
    resulting \linkS4class{GuideSet} object. As placeholder values, NTC
    ranges are set to \code{0} and strands set to \code{*}.
    
    All annotation for NTC spacers appended to \code{object} are set to
    \code{NA} or empty list elements. To annotate NTC spacers, you must call
    the appropriate function after adding NTCs to the \linkS4class{GuideSet}
    object.
}
\examples{
set.seed(1000)
data(guideSetExample, package="crisprDesign")
ntcs <- vapply(1:4, function(x){
    seq <- sample(c("A", "C", "G", "T"), 20, replace=TRUE)
    paste0(seq, collapse="")
}, FUN.VALUE=character(1))
names(ntcs) <- paste0("ntc_", 1:4)
gs <- addNtcs(guideSetExample, ntcs)
gs


}
