% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TxDb2GRangesList.R
\name{TxDb2GRangesList}
\alias{TxDb2GRangesList}
\title{Convert a \linkS4class{TxDb} object into a \linkS4class{GRangesList}}
\usage{
TxDb2GRangesList(
  txdb,
  standardChromOnly = TRUE,
  genome = NULL,
  seqlevelsStyle = c("UCSC", "NCBI")
)
}
\arguments{
\item{txdb}{A \linkS4class{TxDb} object.}

\item{standardChromOnly}{Should only standard chromosomes be kept?
TRUE by default.}

\item{genome}{Optional string specifying genome. e.g. "hg38", to be
added to \code{genome(txdb)}.}

\item{seqlevelsStyle}{String specifying which style should be used
for sequence names. "UCSC" by default (including "chr").
"NCBI" will omit "chr" in the sequence names.}
}
\value{
A named \linkS4class{GRangesList} of length 7 with the
    following elements:
    \code{transcripts}, \code{exons}, \code{introns}, \code{cds},
    \code{fiveUTRs}, \code{threeUTRs} and \code{tss}.
}
\description{
Convenience function to reformat a \linkS4class{TxDb} object
   into a \linkS4class{GRangesList}.
}
\examples{
if (interactive()){
    # To obtain a TxDb for Homo sapiens from Ensembl:
    txdb <- getTxDb()
    
    # To convert to a GRanges list:
    txdb <- TxDb2GRangesList(txdb)
}


}
\seealso{
\code{\link{getTxDb}} to obtain a \linkS4class{TxDb} object.
}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
