% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetics.R
\name{getProtospacerRanges}
\alias{getProtospacerRanges}
\title{Construct a protospacer GRanges from a list of PAM sites}
\usage{
getProtospacerRanges(
  gr = NULL,
  seqnames = NULL,
  pam_site = NULL,
  strand = NULL,
  nuclease = NULL,
  spacer_len = NULL
)
}
\arguments{
\item{gr}{GRanges object of width 1 specifying the coordinates
of the first nucleotide of the PAM sequences.}

\item{seqnames}{Character vector of genomic sequence names.
Ignored if \code{gr} is not NULL.}

\item{pam_site}{Numeric vector specifying the coordinates of the
first nucleotide of the PAM sequences corresponding to the
protospacers. Ignored if \code{gr} is not NULL.}

\item{strand}{Character vector specifying the strand of the protospacer. 
Ignored if \code{gr} is not NULL.}

\item{nuclease}{CrisprNuclease object.}

\item{spacer_len}{Non-negative integer to overwrite the default spacer
    length stored in the CrisprNuclease object.
s}
}
\value{
GRanges object representing genomic coordinates of
    protospacer sequences.
}
\description{
Construct a protospacer GRanges from a list of PAM sites
    using information stored in a CrisprNuclease object.
}
\examples{
data(SpCas9, AsCas12a, package="crisprBase")
library(GenomicRanges)
gr <- GRanges("chr10",
              IRanges(start=c(100,120), width=1),
              strand=c("+","-"))
getProtospacerRanges(gr, nuclease=SpCas9)
getProtospacerRanges(gr, nuclease=AsCas12a)

}
\author{
Jean-Philippe Fortin
}
