% Generated by roxygen2 (4.0.1): do not edit by hand
\name{vegas}
\alias{vegas}
\title{Calculate the P-Value for a Set Using the VEGAS Method}
\usage{
vegas(set, assoc_table, ldMatrix, num_sims = 1000, correction = TRUE,
  seed = NULL, verbose = FALSE)
}
\arguments{
\item{set}{A \code{GeneSet} object containing a set of genes
of interest or a \code{GeneSetCollection} object containing a
collection of GeneSets.}

\item{assoc_table}{An object of class \code{GRanges}. This
object should at least contain columns SNP and P which hold SNP
rsIDs and their corresponding association test p-values,
respectively.}

\item{ldMatrix}{A square, symmetric matrix of LD values, with
each row and column corresponding to each of the items in the
set. The diagonal entries should be 1, indicating the LD
between an item in the set and itself is 1.}

\item{num_sims}{A positive integer value for the number of
simulations to be performed. Default is 1000.}

\item{correction}{A logical argument indicating whether a
value of one should be added to the numerator and denominator 
when calculating
the p-value based upon the simulated statistics. By default,
the correction is added and this argument is TRUE.}

\item{seed}{An integer argument indicating what the random
seed should be set to. This allows for replication of results.
The default is NULL, and a random seed will be set internally.}

\item{verbose}{A logical argument indicating whether output
should be printed. The default is FALSE.}
}
\value{
An object with the corresponding VEGAS results. If set
is a \code{GeneSetCollection} (i.e., multiple sets of
interest), then the corresponding \code{VEGASResultCollection}
is returned. If set is a \code{GeneSet}, a \code{VEGASResult}
object will be returned.
}
\description{
Calculates the p-value representing the association of the set
with the phenotype of interest.
}
\details{
This function calculates a p-value for sets of SNPs that
reside within a gene set collection. We calculate the null
distribution by taking into account the observed correlation
among the SNPs and simulating a specified number of statistics
from which the resulting p-value is calculated.
}
\author{
Caitlin McHugh \email{mchughc@uw.edu}
}
\references{
Liu, Jimmy Z. and Mcrae, Allan F. et al.
A Versatile Gene-Based Test for Genome-Wide Association
Studies.
The American Journal of Human Genetics, 2010.
}

