% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateIndividualPlots.R
\name{generateIndividualPlots}
\alias{generateIndividualPlots}
\title{Generate individual plots from countsimQCReport output}
\usage{
generateIndividualPlots(
  ggplotsRds,
  device = "png",
  outputDir = "./",
  nDatasets = 2
)
}
\arguments{
\item{ggplotsRds}{The path to a .rds file generated by
\code{countsimQCReport} by setting \code{savePlots = TRUE}, or the list of
plots stored in this file.}

\item{device}{One of "eps", "ps", "tex" (pictex), "pdf", "jpeg", "tiff",
"png", "bmp", "svg" or "wmf" (windows only) (will be provided to the
\code{ggsave} function from the \code{ggplot2} package).}

\item{outputDir}{The output directory where the plots should be generated.}

\item{nDatasets}{The number of data sets that are compared in the figures.
This is needed to set the size of the plots correctly.}
}
\value{
Nothing is returned, but plots are generated in the designated
  output directory.
}
\description{
Generate separate plots for all evaluation criteria using the collection of
ggplot objects that can be saved when generating a countsimQC report (by
setting \code{savePlots = TRUE}).
}
\examples{
## Load example data
data(countsimExample)
\dontrun{
## Generate report
countsimQCReport(countsimExample, outputDir = "./",
                 outputFile = "example.html", savePlots = TRUE)
## Generate individual plots
generateIndividualPlots("example_ggplots.rds", nDatasets = 3)
}

}
\author{
Charlotte Soneson
}
