% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleRnival.R
\name{translate_res}
\alias{translate_res}
\title{translate_res}
\usage{
translate_res(SIF, ATT, HMDB_mapper_vec = NULL)
}
\arguments{
\item{SIF}{result SIF of decoupleRnival pipeline}

\item{ATT}{result ATT of decoupleRnival pipeline}

\item{HMDB_mapper_vec}{a named vector with HMDB Ids as names and desired metabolite names as values.}
}
\value{
list with network and attribute tables.
}
\description{
formats the network with readable names
}
\examples{
# Create a meta network data frame
example_SIF <- data.frame(
source = c("GPX1", "Gene863__GPX1"),
target = c("Gene863__GPX1", "Metab__HMDB0003337_c"),
sign = c(1, 1)
)

example_ATT <- data.frame(
Nodes = c("GPX1", "Gene863__GPX1","Metab__HMDB0003337_c"),
sign = c(1, 1, 1)
)

example_SIF

data("HMDB_mapper_vec")

translated_res <- translate_res(example_SIF,example_ATT,HMDB_mapper_vec)

translated_res$SIF
}
