% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_decoupleR.R
\name{translate_column_HMDB}
\alias{translate_column_HMDB}
\title{Translate Column Using HMDB Mapper}
\usage{
translate_column_HMDB(my_column, HMDB_mapper_vec)
}
\arguments{
\item{my_column}{A vector of values to be translated.}

\item{HMDB_mapper_vec}{A named vector where the names are the original identifiers and the values are the corresponding HMDB identifiers.}
}
\value{
A vector with the translated values.
}
\description{
This function translates the values in a column using a provided Human Metabolome Database (HMDB) mapper vector.
It modifies the input values by replacing certain prefixes and suffixes according to specific rules.
}
\examples{
# Create a sample column and HMDB mapper vector
my_column <- c("Metab__1234_a", "Gene5678_b", "Metab__91011_c")
HMDB_mapper_vec <- c("1234" = "HMDB00001", "5678" = "HMDB00002", "91011" = "HMDB00003")

# Translate the column
translated_column <- translate_column_HMDB(my_column, HMDB_mapper_vec)

}
