% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_pheatmap.R
\name{make_heatmap_color_palette}
\alias{make_heatmap_color_palette}
\title{Create Heatmap Color Palette}
\usage{
make_heatmap_color_palette(my_matrix)
}
\arguments{
\item{my_matrix}{A numeric matrix for which the heatmap color palette is to be generated.}
}
\value{
A character vector of colors representing the heatmap color palette based on the input matrix values.
}
\description{
This function generates a color palette suitable for heatmaps based on the values in a matrix. It uses the `createLinearColors` function to generate separate color gradients for positive and negative values.
}
\examples{
# Create a sample matrix
my_matrix <- matrix(c(-3, -1, 0, 1, 3), nrow = 1)

# Generate heatmap color palette
heatmap_palette <- make_heatmap_color_palette(my_matrix)

}
