% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_decoupleR.R
\name{format_LR_ressource}
\alias{format_LR_ressource}
\title{Format Ligand-Receptor Resource}
\usage{
format_LR_ressource(ligrec_ressource)
}
\arguments{
\item{ligrec_ressource}{A data frame representing the ligand-receptor resource with columns for source and target gene symbols.}
}
\value{
A data frame containing the formatted ligand-receptor gene set with columns:
  \item{gene}{The gene symbol from the ligand-receptor pairs.}
  \item{set}{The set identifier combining source and target gene symbols.}
  \item{mor}{Default value set to 1 for all entries.}
  \item{likelihood}{Default value set to 1 for all entries.}
}
\description{
This function formats a ligand-receptor resource by creating a gene set
with source-target pairs, converting it to a long format, and adding
default values for 'mor' and 'likelihood'.
}
\examples{
# Create a sample ligand-receptor resource
ligrec_ressource <- data.frame(source_genesymbol = c("L1", "L2"),
                               target_genesymbol = c("R1", "R2"))

# Format the ligand-receptor resource
formatted_geneset <- format_LR_ressource(ligrec_ressource)

}
