% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosmos_data.R
\name{cosmos_data}
\alias{cosmos_data}
\title{Create Cosmos Data}
\usage{
cosmos_data(
  meta_network,
  tf_regulon = NULL,
  signaling_data,
  metabolic_data,
  expression_data,
  verbose = TRUE
)
}
\arguments{
\item{meta_network}{Prior knowledge network (PKN).  By default COSMOS use a
PKN derived from Omnipath, STITCHdb and Recon3D.  See details on the data 
\code{\link{meta_network}}.}

\item{tf_regulon}{Collection of transcription factor - target interactions.
A default collection from dorothea can be obtained by the 
\code{\link{load_tf_regulon_dorothea}} function.}

\item{signaling_data}{Numerical vector, where names are signaling nodes 
in the PKN and values are from \{1, 0, -1\}.  Continuous data will be 
discretized using the \code{\link{sign}} function.}

\item{metabolic_data}{Numerical vector, where names are metabolic nodes 
in the PKN and values are continuous values that represents log2 fold change 
or t-values from a differential analysis.  These values are compared to 
the simulation results (simulated nodes can take value -1, 0 or 1).}

\item{expression_data}{Numerical vector that represents the results of a 
differential gene expression analysis. Names are gene names using EntrezID 
starting with an X and values are log fold change or t-values. Genes with 
NA values are considered none expressed and they will be removed from the
TF-gene expression interactions.}

\item{verbose}{(default: TRUE) Reports details about the
\code{\link{cosmos_data}} object.}
}
\value{
\code{cosmos data} class instance.
}
\description{
An S3 class that combines the required data into a comprehensive list.  Use 
the \code{\link{preprocess_COSMOS_signaling_to_metabolism}} or 
\code{\link{preprocess_COSMOS_metabolism_to_signaling}} to create an instance.
}
