#' Toy Metabolic Input Data
#' 
#' This metabolic data are a subset from the metabolic measurements of the 786-O cell line from the NCI60 dataset.
#'
#' @docType data
#'
#' @usage data(toy_metabolic_input)
#'
#' @format An object of class \dQuote{\code{numeric}} containing the t-values of
#'   2 metabolites, which are named with metabolite HMDB Ids matching the
#'   toy network.
#'
#' @source Subset of: 
#'   \url{https://github.com/saezlab/COSMOS_MSB/blob/main/data/metab_input_COSMOS.csv}
#' 
#' @references {
#'   Dugourd, A., Kuppe, C. and Sciacovelli, M. et. al. (2021) \emph{Molecular 
#'   Systems Biology}. \bold{17}, e9730.
#' }
#' 
#' @examples
#' data(toy_metabolic_input)
#' 
#' @keywords datasets
"toy_metabolic_input"