% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coseq-package.R
\docType{data}
\name{fietz}
\alias{fietz}
\title{RNA-seq data from the mouse neocortex in Fietz et al. (2012)}
\format{
An ExpressionSet named \code{fietz.eset} containing the phenotype data and
expression data for the Fietz et al. (2012) experiment. Phenotype data may be
accessed using the \code{pData} function, and expression data may be accessed
using the \code{exprs} function.
}
\source{
Digital Expression Explorer (http://dee.bakeridi.edu.au/).
}
\usage{
data(fietz)
}
\value{
Object of class \sQuote{ExpressionSet}. Matrix of counts can be accessed after
loading the \sQuote{Biobase} package and calling \code{exprs(fietz))}.
}
\description{
This dataset represents RNA-seq data from mouse neocortex RNA-seq data in five
embryonic (day 14.5) mice by analyzing the transcriptome of three regions: the
ventricular zone (VZ), subventricular zone (SVZ) and cortical place (CP).
}
\references{
\url{https://perso.math.univ-toulouse.fr/maugis/mixstatseq/packages}

Fietz, S. A., et al. (2012). Transcriptomes
of germinal zones of human and mouse fetal neocortex suggest a role of extracellular
matrix in progenitor self-renewal. Proceedings of the National Academy of Sciences,
109(29):11836-11841.
}
\keyword{datasets}
