% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-functions.R
\name{clusterInertia}
\alias{clusterInertia}
\title{Calculation of within-cluster inertia}
\usage{
clusterInertia(profiles, clusters)
}
\arguments{
\item{profiles}{Matrix, data.frame, or DataFrame containing the (transformed) profiles used for the clustering}

\item{clusters}{Vector of cluster labels corresponding to the observations in \code{profiles}}
}
\value{
Within cluster inertia
}
\description{
Provides the calculation of within-cluster inertia, equivalent to
\deqn{Inertia(k) = \sum_{i \in C_k} (y_{ik} - \mu_k)^2}
where \eqn{\mu_k} is the mean of cluster \emph{k} and \eqn{C_k} corresponds to the set of indices of genes
attributed to cluster \emph{k}.
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
conds <- rep(c("A","B","C","D"), each=2)

## Run the K-means algorithm for logclr profiles for K = 2,..., 20
run_kmeans <- coseq(object=countmat, K=2:20, transformation="logclr",
model="kmeans")
clusterInertia(profiles=tcounts(run_kmeans), clusters=clusters(run_kmeans))

}
\author{
Andrea Rau, Antoine Godichon-Baggioni
}
