% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_embedding.R
\name{plot_embedding_sce}
\alias{plot_embedding_sce}
\title{Plot selected PCs from an embedding saved in a SingleCellExperiment object}
\usage{
plot_embedding_sce(
  sce,
  which_embedding,
  color_attr = NULL,
  color_title = color_attr,
  ellipse_attr = NULL,
  facet_attr = NULL,
  ...
)
}
\arguments{
\item{sce}{\code{\link{SingleCellExperiment}} object; contains the embedding within the \code{reducedDim} slot}

\item{which_embedding}{character; for the embedding to plot}

\item{color_attr}{character; name of the attribute within \code{colData} to use for assigning colors (in lieu of \code{color_vec} in the \code{\link{plot_embedding}} function)}

\item{color_title}{character; title to use for colors legend, defaults to the same as \code{color_attr}}

\item{ellipse_attr}{character; name of the attribute within \code{colData} to use for drawing ellipse(s) (in lieu of \code{ellipse_vec} in the \code{\link{plot_embedding}} function)}

\item{facet_attr}{character; name of the attribute within \code{colData} to use for faceting (in lieu of \code{facet_vec} in the \code{\link{plot_embedding}} function)}

\item{...}{additional optional arguments - see \code{\link{plot_embedding}} function for details on other potential arguments: \code{xpc}, \code{ypc}, \code{plot_title}, \code{color_title} (if title is different from \code{color_attr}), \code{ptsize}, \code{saveplot}, \code{plotfn}, \code{showplot}, \code{returngg}, \code{color_pal_vec}, \code{dimname}}
}
\value{
default none; options to display plot (\code{showplot}), save plot (\code{saveplot}), and/or return \code{\link{ggplot2}} object (\code{returngg})
}
\description{
Plot selected PCs from an embedding saved in a SingleCellExperiment object
}
\examples{
library(DuoClustering2018)
library(SingleCellExperiment)
sce <- sce_full_Zhengmix4eq()[1:100,sample(1:3500,100,replace = FALSE)]
colData(sce)$Method <- matrix(sample(c('Method1','Method2'),100,replace = TRUE))
sce <- corralm(sce, splitby = 'Method')

# to plot and show only
plot_embedding_sce(sce = sce, 
                   which_embedding = 'corralm', 
                   xpc = 1, 
                   plot_title = 'corralm: PC1 by PC2',
                   color_attr = "Method", 
                   ellipse_attr = 'phenoid',
                   saveplot = FALSE)

# to return ggplot2 object and display, but not save
corralm_ggplot <- plot_embedding_sce(sce = sce, 
                                     which_embedding = 'corralm', 
                                     xpc = 1, 
                                     plot_title = 'corralm: PC1 by PC2',
                                     color_attr = 'Method', 
                                     ellipse_attr = 'phenoid', 
                                     returngg = TRUE, 
                                     saveplot = FALSE)


}
