% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corral.R
\name{compsvd}
\alias{compsvd}
\title{compsvd: Compute Singular Value Decomposition (SVD)}
\usage{
compsvd(mat, method = c("irl", "svd"), ncomp = 30, ...)
}
\arguments{
\item{mat}{matrix, pre-processed input; can be sparse or full (pre-processing can be performed using \code{\link{corral_preproc}} from this package)}

\item{method}{character, the algorithm to be used for svd. Default is irl. Currently supports 'irl' for irlba::irlba or 'svd' for stats::svd}

\item{ncomp}{numeric, number of components; Default is 30}

\item{...}{(additional arguments for methods)}
}
\value{
SVD result - a list with the following elements:
\describe{
    \item{\code{d}}{a vector of the diagonal singular values of the input \code{mat}. Note that using \code{svd} will result in the full set of singular values, while \code{irlba} will only compute the first \code{ncomp} singular values.}
    \item{\code{u}}{a matrix of with the left singular vectors of \code{mat} in the columns}
    \item{\code{v}}{a matrix of with the right singular vectors of \code{mat} in the columns}
    \item{\code{eigsum}}{sum of the eigenvalues, for calculating percent variance explained}
}
}
\description{
Computes SVD.
}
\examples{
mat <- matrix(sample(0:10, 2500, replace=TRUE), ncol=50)
compsvd(mat, method = 'irl', ncomp = 5)
}
