% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\docType{methods}
\name{CNV.genomeplot}
\alias{CNV.genomeplot}
\alias{CNV.genomeplot,CNV.analysis-method}
\title{CNV.genomeplot}
\usage{
CNV.genomeplot(object, ...)

\S4method{CNV.genomeplot}{CNV.analysis}(object, chr = "all", chrX = TRUE,
  chrY = TRUE, centromere = TRUE, detail = TRUE, main = NULL,
  ylim = c(-1.25, 1.25), set_par = TRUE, cols = c("red", "red",
  "lightgrey", "green", "green"))
}
\arguments{
\item{object}{\code{CNV.analysis} object.}

\item{...}{Additional parameters (\code{CNV.detailplot} generic, currently not used).}

\item{chr}{character vector. Which chromomsomes to plot. Defaults to \code{'all'}.}

\item{chrX}{logical. Plot values for chrX? Defaults to \code{TRUE}. Set \code{CNV.create_anno(chrXY = FALSE)} if chrX and Y should not be included at all.}

\item{chrY}{logical. Plot values for chrY? Defaults to \code{TRUE}.}

\item{centromere}{logical. Show dashed lines at centromeres? Defaults to \code{TRUE}.}

\item{detail}{logical. If available, include labels of detail regions? Defaults to \code{TRUE}.}

\item{main}{character. Title of the plot. Defaults to sample name.}

\item{ylim}{numeric vector. The y limits of the plot. Defaults to \code{c(-1.25, 1.25)}.}

\item{set_par}{logical. Use recommended graphical parameters for \code{oma} and \code{mar}? Defaults to \code{TRUE}. Original parameters are restored afterwards.}

\item{cols}{character vector. Colors to use for plotting intensity levels of bins. Centered around 0. Defaults to \code{c('red', 'red', 'lightgrey', 'green', 'green')}.}
}
\value{
\code{NULL}.
}
\description{
Create CNV plot for the whole genome or chromosomes.
}
\details{
This method provides the functionality for generating CNV plots for the whole genome or defined chromosomes. Bins are shown as dots, segments are shown as lines. See parameters for more information.
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
data(detail_regions)
anno <- CNV.create_anno(detail_regions = detail_regions)

# create/modify object
x <- CNV.segment(CNV.detail(CNV.bin(CNV.fit(query = d['GroupB_1'],
    ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno))))

# output plots
CNV.genomeplot(x)
CNV.genomeplot(x, chr = 'chr6')
CNV.detailplot(x, name = 'PTEN')
CNV.detailplot_wrap(x)

# output text files
CNV.write(x, what = 'segments')
CNV.write(x, what = 'detail')
CNV.write(x, what = 'bins')
CNV.write(x, what = 'probes')
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
