% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{CNV.analysis-class}
\alias{CNV.analysis-class}
\alias{show,CNV.analysis-method}
\alias{names,CNV.analysis-method}
\alias{names<-,CNV.analysis-method}
\alias{coef,CNV.analysis-method}
\title{CNV.analysis class}
\usage{
\S4method{show}{CNV.analysis}(object)

\S4method{names}{CNV.analysis}(x)

\S4method{names}{CNV.analysis}(x) <- value

\S4method{coef}{CNV.analysis}(object)
}
\arguments{
\item{object}{\code{CNV.analysis} object}

\item{x}{\code{CNV.analysis} object (defined by \code{show} generic).}

\item{value}{Replacement names.}
}
\value{
\code{CNV.analysis} class.
}
\description{
CNV analysis data of a single sample is stored in this class
}
\details{
Use \code{CNV.fit} to create. Modified by \code{CNV.bin}, \code{CNV.detail} and \code{CNV.segment}.
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
anno <- CNV.create_anno()

# create object
x <- CNV.fit(query = d['GroupB_1'], ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno)

# modify object
x <- CNV.bin(x)
x <- CNV.detail(x)
x <- CNV.segment(x)

# general information
x
show(x)

# coefficients of linear regression
coef(x)

# show or replace sample name
names(x)
names(x) <- 'Sample 1'

# output plots
CNV.genomeplot(x)
CNV.genomeplot(x, chr = 'chr6')
#CNV.detailplot(x, name = 'MYCN')
#CNV.detailplot_wrap(x)
CNV.write(x, what = 'segments')
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
