% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSeekeR.R
\docType{data}
\name{A549_CTCF_MYJ_NarrowPeaks_partial}
\alias{A549_CTCF_MYJ_NarrowPeaks_partial}
\title{Sites with the greatest evidence of transcription factor binding
for the CTCF transcription factor (for demonstration purpose)}
\format{
A \code{GRanges} containing one entry per site.
}
\source{
The Encyclopedia of DNA Elements (ENCODE) (DCC accession:
ENCFF000MYJ)
}
\usage{
data(A549_CTCF_MYJ_NarrowPeaks_partial)
}
\description{
Sites representing the greatest evidence of enrichment for
the CTCF transcription factor (DCC accession: ENCFF000MYJ)
for regions chr1:246000000-249250621 and chr10:10000000-12500000
from
the Encyclopedia of DNA Elements (ENCODE) data (Dunham I et al. 2012).
}
\examples{

## Loading datasets
data(A549_CTCF_MYJ_NarrowPeaks_partial)
data(A549_CTCF_MYJ_Peaks_partial)
data(A549_CTCF_MYN_NarrowPeaks_partial)
data(A549_CTCF_MYN_Peaks_partial)

## Assigning experiment name to each row of the dataset.
## NarrowPeak and Peak datasets from the same experiment must
## have identical names.
names(A549_CTCF_MYJ_Peaks_partial) <- rep("CTCF_MYJ",
                            length(A549_CTCF_MYJ_Peaks_partial))
names(A549_CTCF_MYJ_NarrowPeaks_partial) <- rep("CTCF_MYJ",
                            length(A549_CTCF_MYJ_NarrowPeaks_partial))
names(A549_CTCF_MYN_Peaks_partial) <-rep("CTCF_MYN",
                            length(A549_CTCF_MYN_Peaks_partial))
names(A549_CTCF_MYN_NarrowPeaks_partial) <- rep("CTCF_MYN",
                            length(A549_CTCF_MYN_NarrowPeaks_partial))

## Calculating consensus regions for chromosome 10
## with a default region size of 100 bp (2 * extendingSize)
## which is extended to include all genomic regions for the closest
## peak to the median position of all peaks included in the region (for each
## experiment).
## A peak from both experiments must be present in a region to
## be retained as a consensus region.
chrList <- Seqinfo(c("chr10"), c(135534747), NA)
findConsensusPeakRegions(
    narrowPeaks = c(A549_CTCF_MYJ_NarrowPeaks_partial,
                            A549_CTCF_MYN_NarrowPeaks_partial),
    peaks = c(A549_CTCF_MYJ_Peaks_partial,
                            A549_CTCF_MYN_Peaks_partial),
    chrInfo = chrList,
    extendingSize = 50,
    expandToFitPeakRegion = TRUE,
    shrinkToFitPeakRegion = TRUE,
    minNbrExp = 2,
    nbrThreads = 1)

}
\references{
\itemize{
\item Dunham I, Kundaje A, Aldred SF, et al. An integrated encyclopedia
of DNA elements in the human genome. Nature. 2012 Sep 6;489(7414):57-74.
}
}
\seealso{
\itemize{
    \item{\code{\link{A549_CTCF_MYJ_Peaks_partial}} the associate
genomic peaks dataset.}
    \item{\code{\link{findConsensusPeakRegions}} for extracting regions
sharing the same features in more than one experiment.}
}
}
\keyword{datasets}
