% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveReport.R
\name{saveReport}
\alias{saveReport}
\title{Save PDF report with analysis of each independent component}
\usage{
saveReport(
  cica,
  Genes = NULL,
  Var = NULL,
  surv = NULL,
  genenames = NULL,
  file = sprintf("report_ICA_\%d.pdf", ncol(IC$S)),
  main = "Component # \%d (stability = \%.3f)",
  show.components = seq.int(1, ncol(cica$S))
)
}
\arguments{
\item{cica}{list compliant to `consICA()` result. May include GO list with 
enrichment analysis appended with `getGO()` function}

\item{Genes}{features list compilant to `getFeatures` output (list of 
dataframes `pos` for positive and `neg` for negative affecting features with
names of features false discovery rates columns).If NULL will generated 
automatically}

\item{Var}{matrix with samples metadata}

\item{surv}{dataframe with time and event values for each sample}

\item{genenames}{alternative gene names for printing in the report}

\item{file}{report filename, ends with ".pdf"}

\item{main}{title for each list discribes the component}

\item{show.components}{which compont will be shown}
}
\value{
TRUE when successfully generate report
}
\description{
Save PDF report with description of each independent component 
(IC) consists of most affected genes, significant Go terms, survival model
for the component, ANOVA analysis for samples characteristics and stability
}
\examples{
if(FALSE){
  data("samples_data")
  cica <- consICA(samples_data, ncomp=15, ntry=10, ncores = 2, show.every=0)
  if(FALSE){
    cica <- getGO(cica, db = "BP")
  }
  saveReport(cica, Var=samples_data$Var, surv = samples_data$Sur)
}
}
\author{
Petr V. Nazarov
}
