% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceExplained.R
\name{estimateVarianceExplained}
\alias{estimateVarianceExplained}
\title{Estimate the variance explained by the model}
\usage{
estimateVarianceExplained(cica, X = NULL)
}
\arguments{
\item{cica}{list compliant to `consICA()` result}

\item{X}{a `SummarizedExperiment` object. Assay  used for the model. 
Will be used if consICA$X is NULL, ignore otherwise.}
}
\value{
a list of:\cr
    \item{R2}{total variance explained by the model}
    \item{R2_ics}{Amount of variance explained by the each independent 
     component}
}
\description{
The method estimates 
the variance explained by the model and by each independent component.\cr
We used the coefficient of determination (R2) between the normalized 
input (X-mean(X)) and (S*M)
}
\examples{
data("samples_data")
# cica <- consICA(samples_data, ncomp=15, ntry=10, show.every=0)
# var_ic <- estimateVarianceExplained(cica)
}
