% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsAnalysis.R
\name{anovaIC}
\alias{anovaIC}
\title{ANOVA test for independent component across factors}
\usage{
anovaIC(
  cica,
  Var = NULL,
  icomp = 1,
  plot = TRUE,
  mode = "violin",
  color_by_pv = TRUE
)
}
\arguments{
\item{cica}{list compliant to `consICA()` result}

\item{Var}{matrix with samples' metadata. Samples in rows and factors in 
columns}

\item{icomp}{number of component to analyse}

\item{plot}{if plot weights distributions for top factors}

\item{mode}{type of plot. Can be 'violin' or 'box'}

\item{color_by_pv}{if TRUE plots will be colored by p-value ranges}
}
\value{
a data.frame with 
    \item{factor}{name of factor}
    \item{p.value}{p-value for ANOVA test for factor} 
    \item{p.value_disp}{string for p-value printing}
}
\description{
ANOVA (ANalysis Of VAriance) test produced for specific 
independent component across each (clinical) factor as `aov(IC ~ factor)`.
Plot distributions of samples' weight for top 9 significant factors.
}
\examples{
data("samples_data")
# Var <- data.frame(SummarizedExperiment::colData(samples_data))
# cica <-  consICA(samples_data, ncomp=10, ntry=1, ncores=1, show.every=0)
## Run ANOVA for 4th independent component
# anova <- anovaIC(cica, Var=Var, icomp = 4)
}
