% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePhyloPoissonLogNormal.R
\name{get_poisson_log_normal_parameters}
\alias{get_poisson_log_normal_parameters}
\title{Compute log means and variances}
\usage{
get_poisson_log_normal_parameters(
  count_means,
  count_dispersions,
  prop.var.tree
)
}
\arguments{
\item{count_means}{a matrix with the number of genes p rows and the number of
species n columns. Column names should match the tree taxa names.}

\item{count_dispersions}{a matrix of size p x n, for each gene and species.
Column names should match the tree taxa names.}
}
\value{
A list, with:
\describe{
\item{log_means}{the p x n matrix of log-means for Poisson-lognormal simulations.}
\item{log_variance_phylo}{the p vector of phylogenetic log-variances for Poisson-lognormal simulations.}
\item{log_variance_sample}{the p x n matrix of environmental log-variances for Poisson-lognormal simulations.}
}
}
\description{
From the parameters of a negative binomial (count_means and count_dispersions),
compute the parameters of a phylogenetic Poisson log-normal with the
same expectations and variances.
}
\keyword{internal}
