% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildEmptyJac.R
\name{buildEmptyJac}
\alias{buildEmptyJac}
\title{Prepare an empty Jacobian matrix, with useful entries prefilled.
In case of distribution "gaussian", it returns the lhs matrix of the linear system for finding the feature paramters}
\usage{
buildEmptyJac(
  n,
  m,
  lower,
  distribution = "quasi",
  normal = FALSE,
  nLambda1s = 1,
  centMat = NULL,
  weights = 1
)
}
\arguments{
\item{n}{the number of parameters}

\item{m}{the dimension}

\item{lower}{the current parameter estimates}

\item{distribution}{A character string, the distributional assumption for the data}

\item{normal}{a boolean, are normalization restrictions in place?}

\item{nLambda1s}{The number of centering restrictions}

\item{centMat}{The centering matrix}

\item{weights}{Vector of feature weights}
}
\value{
an empty jacobian matrix, or the lhs of the system of estimating equations
}
\description{
Prepare an empty Jacobian matrix, with useful entries prefilled.
In case of distribution "gaussian", it returns the lhs matrix of the linear system for finding the feature paramters
}
