% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-col-mm.R
\name{readColMM}
\alias{readColMM}
\title{readColMM}
\usage{
readColMM(file, which.col, chunk = 1000L)
}
\arguments{
\item{file}{the name of the file to be read from as a character scalar. Those
storing matrices in the MatrixMarket format usually end in ".mtx".}

\item{which.col}{An integer scalar, the column index}

\item{chunk, }{An integer scalar indicating the chunk size to use,
i.e., number of rows to read at any one time.}
}
\value{
A sparse matrix object that inherits from the "Matrix" class which the original
dimensions.To get the vector of the specified column, one need to subset
the matrix to select the column with the same index.
}
\description{
Modified the `Matrix::readMM` function for reading matrices stored in the
Harwell-Boeing or MatrixMarket formats but only reads selected column.
}
\details{
See \code{\link[Matrix]{readMM}}
}
\examples{
demo_path <-paste0(system.file("extdata",package = "comapr"),"/")
readColMM(file = paste0(demo_path,"s1_chr1_vi.mtx"), which.col=2,chunk=2)
}
\author{
Ruqian Lyu
}
